package inc.monsters.mias.backing;

import inc.monsters.mias.data.Kid;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

import org.apache.myfaces.custom.fileupload.UploadedFile;

public class EditKidForm {
	private String firstName;
	private String lastName;
	private Date birthDate;
	private int age;
	private Date lastScared;
	private double braveness;
	private String country;
    private UploadedFile photoFile;

	private Kid selectedKid;
	
	private static final String IMAGE_DIRECTORY = "/usr/share/photos/";

	public void setSelectedKid(Kid selectedKid) {
		this.selectedKid = selectedKid;
		
		this.firstName = selectedKid.getFirstName();
		this.lastName = selectedKid.getLastName();
		this.birthDate = selectedKid.getBirthDate();
		this.age = selectedKid.getAge();
		this.lastScared = selectedKid.getLastScared();
		this.braveness = selectedKid.getBraveness();
		this.country = selectedKid.getCountry();
	}
	
	public String save() {
		doApply();
		return "ok";
	}
	
	public String apply() {
		doApply();
		return "apply";		
	}
	
	private void doApply() {
		if(selectedKid != null) {
			selectedKid.setFirstName(firstName);
			selectedKid.setLastName(lastName);
			selectedKid.setBirthDate(birthDate);
			selectedKid.setLastScared(lastScared);
			selectedKid.setBraveness(braveness);
			selectedKid.setCountry(country);
			savePhoto();
			age = selectedKid.getAge();
		}
	}
	
	private void savePhoto() {
		ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
		context.log("savePhoto()");
		if(photoFile != null) {
			selectedKid.setPhoto(photoFile.getName());
            // Make sure the image directory exists
			// TODO: use same image directory setting as for PhotoServlet
			File f = new File(IMAGE_DIRECTORY);
			if(!f.exists()) {
				f.mkdir();
			}
			f = new File(IMAGE_DIRECTORY + photoFile.getName());
			context.log("savePhoto(): file = " + f.getAbsolutePath());
			FileOutputStream fos;
			try {
				fos = new FileOutputStream(f);
				context.log("savePhoto() : output stream constructed");
				fos.write(photoFile.getBytes());
				context.log("savePhoto() : "+photoFile.getSize()+"bytes written");
				fos.close();
			} catch (FileNotFoundException e) {
				context.log("savePhoto() : FileNotFoundException");
				e.printStackTrace();
			} catch (IOException e) {
				context.log("savePhoto() : IOException");
				e.printStackTrace();
			}
		}
	}
	
	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public Date getBirthDate() {
		return birthDate;
	}

	public void setBirthDate(Date birthDate) {
		this.birthDate = birthDate;
	}

	public int getAge() {
		return age;
	}

	public Date getLastScared() {
		return lastScared;
	}

	public void setLastScared(Date lastScared) {
		this.lastScared = lastScared;
	}

	public double getBraveness() {
		return braveness;
	}

	public void setBraveness(double braveness) {
		this.braveness = braveness;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}
	
	public UploadedFile getPhotoFile() {
		return photoFile;
	}

	public void setPhotoFile(UploadedFile photoFile) {
		this.photoFile = photoFile;
	}
	
	public String getPhotoUrl() {
		ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
		context.log("getPhotoUrl()");
		String photoFileName = selectedKid.getPhoto();
		context.log("getPhotoUrl(): photoFileName = " + photoFileName);
		if(photoFileName != null) {
			photoFileName = "/photos/" + photoFileName;
		} else {
			photoFileName = "";
	    }
		context.log("getPhotoUrl(): photoFileName = " + photoFileName);
		return photoFileName;
	}
}
